<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ config_value('site_name', 'Edge') }} - @yield('title', 'Admin Home')</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css">
    <script src="https://code.jquery.com/jquery-3.7.1.slim.min.js" integrity="sha256-kmHvs0B+OpCW5GVHUNjv9rOmY0IvSIRcf7zGUDTDQM8=" crossorigin="anonymous"></script>
    <link rel="icon" href="{{ config_value('site_favicon', asset('images/logo.png')) }}" type="image/png">

    @vite(['resources/scss/admin.scss', 'resources/js/admin.js'])

    @stack('styles')
</head>
<body class="admin-panel">
    <div class="admin-container">
        <aside class="admin-sidebar">
            <div class="sidebar-header">
                <div class="sidebar-logo">
                    <img src="{{ config_value('site_logo', asset('images/logo.png')) }}" alt="Logo">
                </div>
                <h2>Admin Panel</h2>
                <button class="sidebar-toggle-btn" id="sidebarToggle">
                    <i class="fas fa-bars"></i>
                </button>
            </div>
            
            <div class="sidebar-user">
                <div class="user-avatar">
                    <img src="{{ auth()->user()->avatar }}" alt="{{ auth()->user()->name }}">
                </div>
                <div class="user-info">
                    <h4>{{ auth()->user()->name }}</h4>
                    <span class="user-role">
                        {{ auth()->user()->roles->pluck('name')->implode(', ') }}
                    </span>
                </div>
            </div>
            
            <div class="sidebar-nav">
                {{-- Main Navigation --}}
                <div class="nav-category">Main</div>
                <ul>
                    @can('access dashboard')
                    <li class="{{ request()->routeIs('admin.dashboard') ? 'active' : '' }}">
                        <a href="{{ route('admin.dashboard') }}">
                            <i class="fas fa-tachometer-alt"></i>
                            <span>Dashboard</span>
                        </a>
                    </li>
                    @endcan

                    @can('view error logs')
                    <li class="{{ request()->routeIs('admin.errors.*') ? 'active' : '' }}">
                        <a href="{{ route('admin.errors.index') }}">
                            <i class="fas fa-exclamation-triangle"></i>
                            <span>Error Logs</span>
                            @if(\App\Models\ErrorLog::unresolved()->count() > 0)
                                <span class="badge badge-danger">{{ \App\Models\ErrorLog::unresolved()->count() }}</span>
                            @endif
                        </a>
                    </li>
                    @endcan
                </ul>
            
                {{-- Management Section --}}
                <div class="nav-category">Management</div>
                <ul>
                    @can('view users')
                    <li class="{{ request()->routeIs('admin.users.*') ? 'active' : '' }}">
                        <a href="{{ route('admin.users.index') }}">
                            <i class="fas fa-users"></i>
                            <span>Users</span>
                        </a>
                    </li>
                    @endcan
            
                    @can('view roles')
                    <li class="{{ request()->routeIs('admin.roles*') ? 'active' : '' }}">
                        <a href="{{ route('admin.roles') }}">
                            <i class="fas fa-user-tag"></i>
                            <span>Roles</span>
                        </a>
                    </li>
                    @endcan

                    @can('view permissions')
                    <li class="{{ request()->routeIs('admin.permissions*') ? 'active' : '' }}">
                        <a href="{{ route('admin.permissions') }}">
                            <i class="fas fa-list-check"></i>
                            <span>Permissions</span>
                        </a>
                    </li>
                    @endcan

                    @can('manage server')
                    <li class="{{ request()->routeIs('admin.servers.*') ? 'active' : '' }}">
                        <a href="{{ route('admin.servers.index') }}">
                            <i class="fas fa-server"></i>
                            <span>Servers</span>
                        </a>
                    </li>
                    @endcan

                    @can('manage news')
                   <li class="{{ request()->routeIs('admin.news.*') ? 'active' : '' }}">
                        <a href="{{ route('admin.news.index') }}">
                            <i class="fas fa-scroll"></i>
                            <span>News</span>
                        </a>
                    </li>
                    @endcan

                    {{-- Add plugin items to management category if any exist --}}
                    @if(isset($pluginMenuItems['management']) && !empty($pluginMenuItems['management']['items']))
                        @foreach($pluginMenuItems['management']['items'] as $menuItem)
                            <li class="{{ $menuItem['active_routes'] && request()->routeIs($menuItem['active_routes']) ? 'active' : '' }}">
                                <a href="{{ $menuItem['url'] }}" 
                                   target="{{ $menuItem['target'] ?? '_self' }}"
                                   title="{{ $menuItem['description'] ?? $menuItem['label'] }}">
                                    <i class="{{ $menuItem['icon'] }}"></i>
                                    <span>{{ $menuItem['label'] }}</span>
                                    @if($menuItem['badge'])
                                        <span class="menu-badge">{{ $menuItem['badge'] }}</span>
                                    @endif
                                </a>
                            </li>
                        @endforeach
                    @endif

                    {{-- Plugins Management Link --}}
                    @if(auth()->user()->hasRole('super-admin'))
                    <li class="{{ request()->routeIs('admin.plugins.*') ? 'active' : '' }}">
                        <a href="{{ route('admin.plugins.index') }}">
                            <i class="fas fa-puzzle-piece"></i>
                            <span>Plugins</span>
                        </a>
                    </li>
                    @endif
                </ul>
            
                {{-- Forum Section --}}
                <div class="nav-category">Forum</div>
                <ul>
                    @can('view forum categories')
                    <li class="{{ request()->routeIs('admin.forum.categories*') ? 'active' : '' }}">
                        <a href="{{ route('admin.forum.categories') }}">
                            <i class="fas fa-folder-tree"></i>
                            <span>Categories</span>
                        </a>
                    </li>
                    @endcan
                    
                    @can('view forum boards')
                    <li class="{{ request()->routeIs('admin.forum.boards*') ? 'active' : '' }}">
                        <a href="{{ route('admin.forum.boards') }}">
                            <i class="fas fa-th-list"></i>
                            <span>Boards</span>
                        </a>
                    </li>
                    @endcan
                </ul>
            
                {{-- Billing Section --}}
                <div class="nav-category">Billing</div>
                <ul>
                    @can('view transactions')
                    <li class="{{ request()->routeIs('admin.transactions.*') ? 'active' : '' }}">
                        <a href="{{ route('admin.transactions.index') }}">
                            <i class="fas fa-credit-card"></i>
                            <span>Transactions</span>
                        </a>
                    </li>
                    @endcan
                    
                    @can('view packages')
                    <li class="{{ request()->routeIs('admin.packages.*') ? 'active' : '' }}">
                        <a href="{{ route('admin.packages.index') }}">
                            <i class="fas fa-box"></i>
                            <span>Packages</span>
                        </a>
                    </li>
                    @endcan

                    @can('manage store')
                    <li class="{{ request()->routeIs('admin.coupons.*') ? 'active' : '' }}">
                        <a href="{{ route('admin.coupons.index') }}">
                            <i class="fas fa-tags"></i>
                            <span>Coupons</span>
                        </a>
                    </li>
                    @endcan
                </ul>

                {{-- Configuration Section --}}
                <div class="nav-category">Configuration</div>
                <ul>
                    @can('view configurations')
                    <li class="{{ request()->routeIs('admin.configurations.*') ? 'active' : '' }}">
                        <a href="{{ route('admin.configurations.index') }}">
                            <i class="fas fa-cog"></i>
                            <span>Configurations</span>
                        </a>
                    </li>

                    <li class="{{ request()->routeIs('admin.loading-screen.*') ? 'active' : '' }}">
                        <a href="{{ route('admin.loading-screen.index') }}">
                            <i class="fas fa-spinner"></i>
                            <span>Loading Screen</span>
                        </a>
                    </li>
                    @endcan

                    @can('manage map')
                    <li class="{{ request()->routeIs('admin.map.*') ? 'active' : '' }}">
                        <a href="{{ route('admin.map.editor') }}">
                            <i class="fas fa-map"></i>
                            <span>Interactive Map</span>
                        </a>
                    </li>
                    @endcan
                </ul>

                {{-- Plugin Menu Items --}}
                @if(isset($pluginMenuItems) && !empty($pluginMenuItems))
                    @foreach($pluginMenuItems as $categoryKey => $categoryData)
                        {{-- Skip default categories as they're already rendered above --}}
                        @if(!in_array($categoryKey, ['main', 'management', 'forum', 'billing', 'configuration']))
                            <div class="nav-category">{{ $categoryData['category']['label'] }}</div>
                            <ul>
                                @foreach($categoryData['items'] as $menuItem)
                                    <li class="{{ $menuItem['active_routes'] && request()->routeIs($menuItem['active_routes']) ? 'active' : '' }}">
                                        <a href="{{ $menuItem['url'] }}" 
                                           target="{{ $menuItem['target'] ?? '_self' }}"
                                           title="{{ $menuItem['description'] ?? $menuItem['label'] }}">
                                            <i class="{{ $menuItem['icon'] }}"></i>
                                            <span>{{ $menuItem['label'] }}</span>
                                            @if($menuItem['badge'])
                                                <span class="menu-badge">{{ $menuItem['badge'] }}</span>
                                            @endif
                                        </a>
                                    </li>
                                @endforeach
                            </ul>
                        @endif
                    @endforeach
                @endif

                {{-- Add plugin items to existing categories --}}
                @if(isset($pluginMenuItems))
                    @foreach(['main', 'management', 'forum', 'billing', 'configuration'] as $categoryKey)
                        @if(isset($pluginMenuItems[$categoryKey]) && !empty($pluginMenuItems[$categoryKey]['items']))
                            {{-- Plugin items for existing categories would be added inline above, 
                                 this is handled by the view composer --}}
                        @endif
                    @endforeach
                @endif
            </div>
            
            <div class="sidebar-footer">
                <a href="{{ route('home') }}" title="Back to Site">
                    <i class="fas fa-home"></i>
                </a>
                <a href="{{ route('logout') }}" 
                   onclick="event.preventDefault(); document.getElementById('logout-form').submit();" 
                   title="Logout">
                    <i class="fas fa-sign-out-alt"></i>
                </a>
                <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                    @csrf
                </form>
            </div>
        </aside>
        
        <main class="admin-main">
            <header class="admin-header">
                <div class="header-left">
                    <button class="menu-toggle" id="menuToggle">
                        <i class="fas fa-bars"></i>
                    </button>
                    <h1>@yield('title', 'Dashboard')</h1>
                </div>
                <div class="header-right">
                    <div class="header-user">
                        <button class="user-dropdown-btn">
                            <img src="{{ auth()->user()->avatar }}" alt="{{ auth()->user()->name }}">
                            <span>{{ auth()->user()->name }}</span>
                            <i class="fas fa-chevron-down"></i>
                        </button>
                        <div class="user-dropdown">
                            <ul>
                                <li>
                                    <a href="{{ route('logout') }}" 
                                       onclick="event.preventDefault(); document.getElementById('logout-form-header').submit();">
                                        <i class="fas fa-sign-out-alt"></i>
                                        <span>Logout</span>
                                    </a>
                                    <form id="logout-form-header" action="{{ route('logout') }}" method="POST" class="d-none">
                                        @csrf
                                    </form>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </header>
            
            <div class="admin-content">
                @if (session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
                @endif
                
                @if (session('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
                @endif
                
                @yield('content')
            </div>
            
            <footer class="admin-footer">
                <p>Edge v1.1.2</p>
            </footer>
        </main>
    </div>

    @stack('scripts')
</body>
</html>